import { NextResponse } from "next/server";
import { prisma } from "@/lib/prisma";
import { hashPassword } from "@/lib/auth";

export const dynamic = "force-dynamic";

export async function POST(req: Request) {
  const body = await req.json();
  const { firstName, lastName, email, password } = body;

  if (!firstName || !lastName || !email || !password) {
    return NextResponse.json({ error: "Tüm alanlar zorunlu." }, { status: 400 });
  }

  const existing = await prisma.user.findUnique({ where: { email } });
  if (existing) {
    return NextResponse.json({ error: "E-posta zaten kayıtlı." }, { status: 409 });
  }

  const hashed = await hashPassword(password);
  await prisma.user.create({
    data: {
      firstName,
      lastName,
      email,
      password: hashed
    }
  });

  return NextResponse.json({ ok: true });
}
