import "./globals.css";
import Link from "next/link";
import { getSession } from "@/lib/auth";

export const metadata = {
  title: "SerUP Dev Platform",
  description: "Modern developer platform with RBAC and spotlight"
};

export default async function RootLayout({ children }: { children: React.ReactNode }) {
  const session = await getSession();

  return (
    <html lang="tr">
      <body>
        <header className="border-b border-slate-800">
          <nav className="mx-auto flex max-w-6xl items-center justify-between px-6 py-4">
            <Link href="/" className="font-semibold tracking-wide text-cyan-400">
              SerUP
            </Link>
            <div className="flex items-center gap-4 text-sm">
              {session ? (
                <>
                  <span>
                    {session.firstName} {session.lastName} ({session.role})
                  </span>
                  {session.role === "ADMIN" && (
                    <Link href="/admin" className="text-cyan-400 hover:text-cyan-300">
                      Admin
                    </Link>
                  )}
                </>
              ) : (
                <>
                  <Link href="/auth/login">Giriş</Link>
                  <Link href="/auth/register">Kayıt</Link>
                </>
              )}
            </div>
          </nav>
        </header>
        <main className="mx-auto max-w-6xl px-6 py-8">{children}</main>
      </body>
    </html>
  );
}
