import { SpotlightType } from "@prisma/client";
import { prisma } from "@/lib/prisma";

export async function Spotlight() {
  let activeSpotlight = null;

  try {
    activeSpotlight = await prisma.spotlight.findFirst({
      where: { isActive: true },
      orderBy: { id: "desc" }
    });
  } catch {
    activeSpotlight = null;
  }

  if (!activeSpotlight) {
    return (
      <section className="rounded-2xl border border-slate-800 bg-slate-900/50 p-6">
        <h2 className="text-xl font-semibold">Spotlight</h2>
        <p className="mt-2 text-slate-300">Aktif spotlight bulunamadı.</p>
      </section>
    );
  }

  if (activeSpotlight.type === SpotlightType.SPONSOR) {
    return (
      <section className="rounded-2xl border border-cyan-600/40 bg-cyan-600/10 p-6">
        <p className="text-xs uppercase tracking-[0.2em] text-cyan-300">Sponsor Spotlight</p>
        <h2 className="mt-2 text-2xl font-semibold">{activeSpotlight.title}</h2>
        {activeSpotlight.link && (
          <a className="mt-4 inline-block text-cyan-300 underline" href={activeSpotlight.link} target="_blank">
            İş birliği linkine git
          </a>
        )}
      </section>
    );
  }

  return (
    <section className="rounded-2xl border border-purple-600/40 bg-purple-600/10 p-6">
      <p className="text-xs uppercase tracking-[0.2em] text-purple-300">Haftanın Kodu</p>
      <h2 className="mt-2 text-2xl font-semibold">{activeSpotlight.title}</h2>
      <pre className="mt-4">
        <code>{activeSpotlight.codeBody ?? "Kod henüz eklenmedi."}</code>
      </pre>
    </section>
  );
}
