<?php
require_once __DIR__ . '/db.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

function current_user(): ?array
{
    if (empty($_SESSION['user_id'])) {
        return null;
    }

    $stmt = db()->prepare('SELECT id, first_name, last_name, email, role FROM users WHERE id = :id');
    $stmt->execute(['id' => $_SESSION['user_id']]);
    $user = $stmt->fetch();

    return $user ?: null;
}

function require_login(): array
{
    $user = current_user();
    if (!$user) {
        header('Location: /login.php');
        exit;
    }
    return $user;
}

function require_admin(): array
{
    $user = require_login();
    if ($user['role'] !== 'ADMIN') {
        http_response_code(403);
        echo 'Forbidden';
        exit;
    }
    return $user;
}

function log_action(?string $actorId, string $action, ?string $target, ?string $description): void
{
    $stmt = db()->prepare('INSERT INTO audit_logs (actor_id, action, target, description) VALUES (:actor_id, :action, :target, :description)');
    $stmt->execute([
        'actor_id' => $actorId,
        'action' => $action,
        'target' => $target,
        'description' => $description,
    ]);
}
