import { PrismaClient, Role, SpotlightType } from "@prisma/client";
import { hashSync } from "bcryptjs";

const prisma = new PrismaClient();

async function main() {
  const adminEmail = "admin@serup.dev";

  await prisma.user.upsert({
    where: { email: adminEmail },
    update: {},
    create: {
      firstName: "Platform",
      lastName: "Admin",
      email: adminEmail,
      password: hashSync("Admin123!", 12),
      role: Role.ADMIN
    }
  });

  const spotlightCount = await prisma.spotlight.count();

  if (!spotlightCount) {
    await prisma.spotlight.createMany({
      data: [
        {
          type: SpotlightType.SPONSOR,
          title: "SerUP Partner Program",
          link: "https://serup.com",
          isActive: true
        },
        {
          type: SpotlightType.WEEKLY_CODE,
          title: "Haftanın Kodu: Güvenli role guard",
          codeBody: "if (session.user.role !== 'ADMIN') throw new Error('Forbidden');",
          isActive: true
        }
      ]
    });
  }
}

main()
  .then(() => prisma.$disconnect())
  .catch(async (error) => {
    console.error(error);
    await prisma.$disconnect();
    process.exit(1);
  });
