<?php
require_once __DIR__ . '/../includes/auth.php';
$admin = require_admin();

$search = trim($_GET['q'] ?? '');
$params = [];
$sql = 'SELECT id, first_name, last_name, email, role, created_at FROM users';
if ($search !== '') {
    $sql .= " WHERE LOWER(CONCAT_WS(' ', first_name, last_name, email, role::text)) LIKE :q";
    $params['q'] = '%' . strtolower($search) . '%';
}
$sql .= ' ORDER BY created_at DESC';
$stmt = db()->prepare($sql);
$stmt->execute($params);
$users = $stmt->fetchAll();

$logs = db()->query('SELECT l.*, u.first_name, u.last_name, u.email FROM audit_logs l LEFT JOIN users u ON u.id = l.actor_id ORDER BY l.created_at DESC LIMIT 20')->fetchAll();
?>
<!doctype html>
<html><head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1"><link rel="stylesheet" href="/assets/style.css"><script src="/assets/app.js" defer></script></head>
<body><div class="container">
<div class="nav"><strong>Admin Panel</strong><div><a href="/">Ana Sayfa</a></div></div>

<div class="card">
  <h2>Kullanıcı Yönetimi</h2>
  <form method="get"><input name="q" value="<?= htmlspecialchars($search) ?>" placeholder="Ara (ad/soyad/e-posta/rol)"></form>
  <table class="table">
    <thead><tr><th>Ad Soyad</th><th>E-posta</th><th>Rol</th><th>İşlem</th></tr></thead>
    <tbody>
      <?php foreach ($users as $u): ?>
      <tr>
        <td><?= htmlspecialchars($u['first_name'] . ' ' . $u['last_name']) ?></td>
        <td><?= htmlspecialchars($u['email']) ?></td>
        <td>
          <select onchange="updateRole('<?= $u['id'] ?>', this.value)">
            <?php foreach (['USER','MODERATOR','ADMIN'] as $role): ?>
              <option value="<?= $role ?>" <?= $u['role'] === $role ? 'selected' : '' ?>><?= $role ?></option>
            <?php endforeach; ?>
          </select>
        </td>
        <td><button type="button" onclick="triggerReset('<?= $u['id'] ?>')">Şifre Sıfırlama Linki</button></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<div class="card">
  <h2>Sistem Logları</h2>
  <?php foreach ($logs as $log): ?>
    <p><strong><?= htmlspecialchars($log['action']) ?></strong> → <?= htmlspecialchars($log['target'] ?? '-') ?><br>
      <span class="badge"><?= htmlspecialchars($log['description'] ?? 'Açıklama yok') ?> | Actor: <?= htmlspecialchars(trim(($log['first_name'] ?? '') . ' ' . ($log['last_name'] ?? '')) ?: 'System') ?> | <?= htmlspecialchars($log['created_at']) ?></span></p>
  <?php endforeach; ?>
</div>

</div></body></html>
