<?php
require_once __DIR__ . '/../../includes/auth.php';
header('Content-Type: application/json');
$admin = require_admin();
$body = json_decode(file_get_contents('php://input'), true);
$userId = $body['userId'] ?? null;

if (!$userId) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'message' => 'Eksik userId']);
    exit;
}

$token = sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x', random_int(0, 65535), random_int(0, 65535), random_int(0, 65535), random_int(16384, 20479), random_int(32768, 49151), random_int(0, 65535), random_int(0, 65535), random_int(0, 65535));
$expiresAt = date('Y-m-d H:i:s', time() + 1800);
$stmt = db()->prepare('INSERT INTO password_reset_tokens (token, user_id, expires_at) VALUES (:token, :user_id, :expires_at)');
$stmt->execute(['token' => $token, 'user_id' => $userId, 'expires_at' => $expiresAt]);

$base = (!empty($_SERVER['HTTPS']) ? 'https' : 'http') . '://' . ($_SERVER['HTTP_HOST'] ?? 'localhost:8000');
$resetLink = $base . '/reset-password.php?token=' . $token;
log_action($admin['id'], 'PASSWORD_RESET_LINK_TRIGGERED', $userId, 'Password reset link generated by admin');

echo json_encode(['ok' => true, 'resetLink' => $resetLink]);
