<?php
require_once __DIR__ . '/../../includes/auth.php';
header('Content-Type: application/json');
$admin = require_admin();
$body = json_decode(file_get_contents('php://input'), true);
$userId = $body['userId'] ?? null;
$role = $body['role'] ?? null;

if (!$userId || !in_array($role, ['USER','MODERATOR','ADMIN'], true)) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'message' => 'Geçersiz istek']);
    exit;
}

$stmt = db()->prepare('UPDATE users SET role = :role WHERE id = :id');
$stmt->execute(['role' => $role, 'id' => $userId]);
log_action($admin['id'], 'USER_ROLE_UPDATED', $userId, 'Role set to ' . $role);

echo json_encode(['ok' => true, 'message' => 'Rol güncellendi']);
