async function updateRole(userId, role) {
  const res = await fetch('/api/update_role.php', {
    method: 'POST',
    headers: {'Content-Type':'application/json'},
    body: JSON.stringify({userId, role})
  });
  const data = await res.json();
  alert(data.message || (data.ok ? 'Güncellendi' : 'Hata'));
  if (data.ok) location.reload();
}

async function triggerReset(userId) {
  const res = await fetch('/api/reset_password.php', {
    method: 'POST',
    headers: {'Content-Type':'application/json'},
    body: JSON.stringify({userId})
  });
  const data = await res.json();
  alert(data.ok ? `Reset link: ${data.resetLink}` : data.message);
}
