<?php
require_once __DIR__ . '/../includes/auth.php';
$user = current_user();

$spot = null;
try {
    $stmt = db()->query('SELECT * FROM spotlight WHERE is_active = TRUE ORDER BY id DESC LIMIT 1');
    $spot = $stmt->fetch();
} catch (Throwable $e) {
    $spot = null;
}
?>
<!doctype html>
<html lang="tr">
<head><meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1"><title>SerUP</title><link rel="stylesheet" href="/assets/style.css"></head>
<body>
<div class="container">
  <div class="nav">
    <strong>SerUP Dev Platform</strong>
    <div>
      <?php if ($user): ?>
        <span class="badge"><?= htmlspecialchars($user['first_name'] . ' ' . $user['last_name']) ?> (<?= $user['role'] ?>)</span>
        <?php if ($user['role'] === 'ADMIN'): ?><a href="/admin.php">Admin</a><?php endif; ?>
        <a href="/logout.php">Çıkış</a>
      <?php else: ?>
        <a href="/login.php">Giriş</a> | <a href="/register.php">Kayıt</a>
      <?php endif; ?>
    </div>
  </div>

  <div class="card">
    <h1>Hero Spotlight</h1>
    <?php if (!$spot): ?>
      <p>Aktif spotlight bulunamadı.</p>
    <?php elseif ($spot['type'] === 'SPONSOR'): ?>
      <p class="badge">SPONSOR</p>
      <h2><?= htmlspecialchars($spot['title']) ?></h2>
      <?php if (!empty($spot['link'])): ?><a href="<?= htmlspecialchars($spot['link']) ?>" target="_blank">Sponsor bağlantısı</a><?php endif; ?>
    <?php else: ?>
      <p class="badge">WEEKLY_CODE</p>
      <h2><?= htmlspecialchars($spot['title']) ?></h2>
      <pre class="code"><code><?= htmlspecialchars($spot['code_body'] ?? 'Kod yok') ?></code></pre>
    <?php endif; ?>
  </div>
</div>
</body>
</html>
