<?php
require_once __DIR__ . '/../includes/auth.php';
$error = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $first = trim($_POST['first_name'] ?? '');
    $last = trim($_POST['last_name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';

    if (!$first || !$last || !$email || !$password) {
        $error = 'Tüm alanlar zorunlu';
    } else {
        $hash = password_hash($password, PASSWORD_BCRYPT);
        try {
            $stmt = db()->prepare('INSERT INTO users (first_name, last_name, email, password) VALUES (:first, :last, :email, :password)');
            $stmt->execute(['first' => $first, 'last' => $last, 'email' => $email, 'password' => $hash]);
            header('Location: /login.php');
            exit;
        } catch (Throwable $e) {
            $error = 'Bu e-posta kayıtlı olabilir.';
        }
    }
}
?>
<!doctype html><html><head><meta charset="utf-8"><link rel="stylesheet" href="/assets/style.css"></head><body><div class="container"><div class="card"><h2>Kayıt</h2><?php if ($error): ?><p><?= $error ?></p><?php endif; ?><form method="post"><input name="first_name" placeholder="Ad" required><input name="last_name" placeholder="Soyad" required><input type="email" name="email" placeholder="E-posta" required><input type="password" name="password" placeholder="Şifre" required><button>Kayıt Ol</button></form></div></div></body></html>
